/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config.gui.screen.content.component;

import io.github.noeppi_noeppi.libx.config.gui.ConfigEditor;
import io.github.noeppi_noeppi.libx.config.gui.ConfigScreenContent;
import io.github.noeppi_noeppi.libx.config.gui.EditorOps;
import io.github.noeppi_noeppi.libx.config.gui.WidgetProperties;
import io.github.noeppi_noeppi.libx.impl.config.gui.EditorHelper;
import io.github.noeppi_noeppi.libx.impl.config.gui.screen.content.ListContent;
import io.github.noeppi_noeppi.libx.impl.config.gui.screen.content.component.ComponentType;
import io.github.noeppi_noeppi.libx.impl.config.gui.screen.content.component.PreviewWidget;
import io.github.noeppi_noeppi.libx.impl.config.gui.screen.content.component.type.KeybindComponentType;
import io.github.noeppi_noeppi.libx.impl.config.gui.screen.content.component.type.TextComponentType;
import io.github.noeppi_noeppi.libx.impl.config.gui.screen.content.component.type.TranslationComponentType;
import io.github.noeppi_noeppi.libx.impl.config.gui.screen.widget.TextWidget;
import io.github.noeppi_noeppi.libx.screen.ColorPicker;
import io.github.noeppi_noeppi.libx.util.CachedValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ComponentContent
implements ConfigScreenContent<Component> {
    @Nullable
    private final Component nonEditable;
    private Consumer<Component> inputChanged;
    private final Map<ComponentType<?>, MutableComponent> typeMap;
    private ComponentType<?> currentType;
    private MutableComponent base;
    private StyleSetting bold;
    private StyleSetting italic;
    private StyleSetting underlined;
    private StyleSetting strikethrough;
    private StyleSetting obfuscated;
    private boolean hasColor;
    private TextColor color;
    private List<Component> siblings;
    private final CachedValue<Component> result;
    private final ConfigEditor<ComponentType<?>> typeEditor;
    private final ConfigEditor<StyleSetting> boldEditor;
    private final ConfigEditor<StyleSetting> italicEditor;
    private final ConfigEditor<StyleSetting> underlinedEditor;
    private final ConfigEditor<StyleSetting> strikethroughEditor;
    private final ConfigEditor<StyleSetting> obfuscatedEditor;
    private final ConfigEditor<List<Component>> siblingEditor;
    private TextWidget previewWidget;
    private AbstractWidget typeWidget;
    private AbstractWidget boldWidget;
    private AbstractWidget italicWidget;
    private AbstractWidget underlinedWidget;
    private AbstractWidget strikethroughWidget;
    private AbstractWidget obfuscatedWidget;
    private ColorPicker colorWidget;
    private AbstractWidget siblingWidget;

    public ComponentContent(@Nonnull Component value) {
        List<KeybindComponentType> types = List.of(new TextComponentType(), new TranslationComponentType(), new KeybindComponentType());
        this.typeMap = new HashMap();
        ComponentType type = null;
        MutableComponent cmp = null;
        for (ComponentType componentType : types) {
            if (cmp == null) {
                cmp = componentType.init(value, c -> {
                    this.typeMap.put(t, (MutableComponent)c);
                    if (this.currentType == t) {
                        this.base = c;
                        this.update();
                    }
                });
                if (cmp == null) continue;
                type = componentType;
                continue;
            }
            componentType.init(value, c -> {
                this.typeMap.put(t, (MutableComponent)c);
                if (this.currentType == t) {
                    this.base = c;
                    this.update();
                }
            });
        }
        if (type == null) {
            this.nonEditable = value;
        } else {
            this.nonEditable = null;
            this.currentType = type;
            this.typeMap.put(type, cmp);
            this.base = cmp;
            Style style = value.m_7383_();
            this.bold = StyleSetting.get(style.f_131102_);
            this.italic = StyleSetting.get(style.f_131103_);
            this.underlined = StyleSetting.get(style.f_131104_);
            this.strikethrough = StyleSetting.get(style.f_131105_);
            this.obfuscated = StyleSetting.get(style.f_131106_);
            this.hasColor = style.m_131135_() != null;
            this.color = style.m_131135_() == null ? TextColor.m_131266_((int)0xFFFFFF) : style.m_131135_();
            this.siblings = value.m_7360_();
        }
        this.typeEditor = ConfigEditor.toggle(types, ComponentType::name);
        this.boldEditor = ConfigEditor.toggle(List.of(StyleSetting.INHERIT, StyleSetting.TRUE, StyleSetting.FALSE), s -> new TranslatableComponent("libx.config.gui.component.bold", new Object[]{new TranslatableComponent("libx.config.gui.component.style_setting." + s.value)}));
        this.italicEditor = ConfigEditor.toggle(List.of(StyleSetting.INHERIT, StyleSetting.TRUE, StyleSetting.FALSE), s -> new TranslatableComponent("libx.config.gui.component.italic", new Object[]{new TranslatableComponent("libx.config.gui.component.style_setting." + s.value)}));
        this.underlinedEditor = ConfigEditor.toggle(List.of(StyleSetting.INHERIT, StyleSetting.TRUE, StyleSetting.FALSE), s -> new TranslatableComponent("libx.config.gui.component.underlined", new Object[]{new TranslatableComponent("libx.config.gui.component.style_setting." + s.value)}));
        this.strikethroughEditor = ConfigEditor.toggle(List.of(StyleSetting.INHERIT, StyleSetting.TRUE, StyleSetting.FALSE), s -> new TranslatableComponent("libx.config.gui.component.strikethrough", new Object[]{new TranslatableComponent("libx.config.gui.component.style_setting." + s.value)}));
        this.obfuscatedEditor = ConfigEditor.toggle(List.of(StyleSetting.INHERIT, StyleSetting.TRUE, StyleSetting.FALSE), s -> new TranslatableComponent("libx.config.gui.component.obfuscated", new Object[]{new TranslatableComponent("libx.config.gui.component.style_setting." + s.value)}));
        this.siblingEditor = ConfigEditor.custom(List.of(), l -> new ListContent<Component>(l, ConfigEditor.custom(new TextComponent(""), ComponentContent::new)){

            @Override
            public Component message() {
                return new TranslatableComponent("libx.config.gui.component.siblings");
            }
        });
        this.result = new CachedValue<Component>(() -> {
            if (this.nonEditable != null) {
                return this.nonEditable;
            }
            MutableComponent tc = this.base.m_6881_();
            Style style = Style.f_131099_.m_131136_(this.bold.value).m_131155_(this.italic.value).m_131162_(this.underlined.value).m_178522_(this.strikethrough.value).m_178524_(this.obfuscated.value);
            if (this.hasColor) {
                style = style.m_131148_(this.color);
            }
            tc.m_6270_(style);
            this.siblings.forEach(arg_0 -> ((MutableComponent)tc).m_7220_(arg_0));
            this.inputChanged.accept((Component)tc);
            return tc;
        });
    }

    @Override
    public Component title() {
        return new TranslatableComponent("libx.config.gui.component.title");
    }

    @Override
    public Component message() {
        return this.result.get();
    }

    @Override
    public boolean searchable() {
        return false;
    }

    @Override
    public void init(Consumer<Component> inputChanged) {
        this.inputChanged = inputChanged;
    }

    private void update() {
        this.result.invalidate();
        if (this.previewWidget != null) {
            this.previewWidget.m_93666_(this.result.get());
        }
        if (this.inputChanged != null) {
            this.inputChanged.accept(this.result.get());
        }
    }

    @Override
    public void buildGui(Screen screen, ConfigScreenContent.ScreenManager manager, String search, Consumer<AbstractWidget> consumer) {
        int y = 0;
        this.previewWidget = new PreviewWidget(screen, 20, y, screen.f_96543_ - 40, 36, this.result.get());
        consumer.accept(this.previewWidget);
        y += 44;
        if (this.nonEditable != null) {
            consumer.accept(new TextWidget(screen, 20, y, screen.f_96543_ - 40, 18, (Component)new TranslatableComponent("libx.config.gui.component.no_edit"), List.of()));
            return;
        }
        WidgetProperties<ComponentType> typeProperties = new WidgetProperties<ComponentType>(5, y, 180, 20, type -> {
            this.currentType = type;
            this.base = this.typeMap.getOrDefault(type, (MutableComponent)type.defaultValue());
            this.update();
            manager.rebuild();
        });
        this.typeWidget = EditorHelper.create(screen, this.typeEditor, this.currentType, this.typeWidget, typeProperties);
        consumer.accept(this.typeWidget);
        AtomicInteger atomicY = new AtomicInteger(y += 27);
        this.currentType.buildGui(screen, manager, atomicY, consumer);
        y = atomicY.get();
        int width = Math.min(180, (screen.f_96543_ - 10 - 10) / 3);
        WidgetProperties<StyleSetting> boldProperties = new WidgetProperties<StyleSetting>(5, y += 8, width, 20, bold -> {
            this.bold = bold;
            this.update();
        });
        this.boldWidget = EditorHelper.create(screen, this.boldEditor, this.bold, this.boldWidget, boldProperties);
        consumer.accept(this.boldWidget);
        WidgetProperties<StyleSetting> italicProperties = new WidgetProperties<StyleSetting>(10 + width, y, width, 20, italic -> {
            this.italic = italic;
            this.update();
        });
        this.italicWidget = EditorHelper.create(screen, this.italicEditor, this.italic, this.italicWidget, italicProperties);
        consumer.accept(this.italicWidget);
        WidgetProperties<StyleSetting> underlinedProperties = new WidgetProperties<StyleSetting>(15 + 2 * width, y, width, 20, underlined -> {
            this.underlined = underlined;
            this.update();
        });
        this.underlinedWidget = EditorHelper.create(screen, this.underlinedEditor, this.underlined, this.underlinedWidget, underlinedProperties);
        consumer.accept(this.underlinedWidget);
        WidgetProperties<StyleSetting> strikethroughProperties = new WidgetProperties<StyleSetting>(5, y += 23, width, 20, strikethrough -> {
            this.strikethrough = strikethrough;
            this.update();
        });
        this.strikethroughWidget = EditorHelper.create(screen, this.strikethroughEditor, this.strikethrough, this.strikethroughWidget, strikethroughProperties);
        consumer.accept(this.strikethroughWidget);
        WidgetProperties<StyleSetting> obfuscatedProperties = new WidgetProperties<StyleSetting>(10 + width, y, width, 20, obfuscated -> {
            this.obfuscated = obfuscated;
            this.update();
        });
        this.obfuscatedWidget = EditorHelper.create(screen, this.obfuscatedEditor, this.obfuscated, this.obfuscatedWidget, obfuscatedProperties);
        consumer.accept(this.obfuscatedWidget);
        Checkbox hasColorWidget = new Checkbox(14, (y += 25) + 40, 20, 20, (Component)new TextComponent(""), this.hasColor, false){

            public void m_5691_() {
                super.m_5691_();
                ComponentContent.this.hasColor = this.m_93840_();
                EditorOps.wrap((Widget)ComponentContent.this.colorWidget).enabled(ComponentContent.this.hasColor);
                ComponentContent.this.update();
            }
        };
        consumer.accept((AbstractWidget)hasColorWidget);
        this.colorWidget = new ColorPicker(screen, 37, y, this.colorWidget);
        this.colorWidget.setColor(this.color);
        this.colorWidget.setResponder(color -> {
            this.color = color;
            this.update();
        });
        EditorOps.wrap((Widget)this.colorWidget).enabled(this.hasColor);
        consumer.accept(this.colorWidget);
        WidgetProperties<List> siblingProperties = new WidgetProperties<List>(5, y += 105, 180, 20, siblings -> {
            this.siblings = siblings;
            this.update();
        });
        this.siblingWidget = EditorHelper.create(screen, this.siblingEditor, this.siblings, this.siblingWidget, siblingProperties);
        consumer.accept(this.siblingWidget);
    }

    private static enum StyleSetting {
        INHERIT(null),
        TRUE(true),
        FALSE(false);

        @Nullable
        public final Boolean value;

        private StyleSetting(Boolean value) {
            this.value = value;
        }

        public static StyleSetting get(@Nullable Boolean value) {
            if (value == null) {
                return INHERIT;
            }
            return value != false ? TRUE : FALSE;
        }
    }
}

